import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import javax.swing.WindowConstants;
import javax.swing.border.BevelBorder;
import javax.swing.SwingUtilities;
import java.io.*;
import java.net.*;


/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/

class Receiver extends Thread
{
	private FrontEnd frontend;
	public Receiver(FrontEnd front)
	{
		frontend=front;
	}
	public void run()
	{
		try {
			DatagramSocket socket = new DatagramSocket(frontend.FrontEndport,InetAddress.getByName(frontend.FrontEndIP));
			while (true)
			{
				DatagramPacket message = new DatagramPacket(new byte[100000],100000);
				socket.receive(message);	
				
				String received = new String(message.getData(), 0, message.getLength()-1);
				
				if (received.length()>0)
				{
					
					String action = received.substring(1,9);
					if (action.equals("Response"))
					{
						received = received.substring(10, received.length()-11);
						frontend.addText(received);
					}
				}
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}

public class FrontEnd extends javax.swing.JFrame {
	public static final int FrontEndport = 33148;
	public static final String FrontEndIP = "127.0.0.1";
	private JSeparator jSeparator1;
	private JSeparator jSeparator2;
	private JPanel jPanel1;
	private AbstractAction abstractAction1;
	private JLabel jLabel22;
	private JPanel jPanel18;
	private AbstractAction abstractAction2;
	private JButton SendStepsPerIteration;
	private JTextField StepsPerIteration;
	private JLabel jLabel21;
	private JPanel jPanel17;
	private JTextArea jTextArea1;
	private JScrollPane jScrollPane1;
	private AbstractAction LoadFromFileAction;
	private JButton SendLoadFromFile;
	private JTextField LoadFileName;
	private JLabel jLabel20;
	private JPanel jPanel16;
	private JTextField SaveFileName;
	private AbstractAction SendSaveFileAction;
	private JButton SendSaveToFile;
	private JLabel jLabel19;
	private JPanel jPanel15;
	private AbstractAction SendPositionAction;
	private JButton SendPosition;
	private JLabel jLabel18;
	private JLabel jLabel17;
	private JTextField PositionZ;
	private JLabel jLabel16;
	private JTextField PositionY;
	private JLabel jLabel15;
	private JTextField PositionX;
	private JLabel jLabel14;
	private JLabel jLabel13;
	private JTextField EntityPositionId;
	private JLabel jLabel12;
	private JLabel jLabel11;
	private JPanel jPanel14;
	private AbstractAction SendWorldHardnessAction;
	private AbstractAction SendFastModeAction;
	private AbstractAction ClearMessagesAction;
	private JButton ClearMessages;
	private AbstractAction AutoAdjustModeAction;
	private JButton SendAutoAdjustMode;
	private JComboBox jComboBox2;
	private JLabel jLabel23;
	private JPanel jPanel20;
	private JPanel jPanel19;
	private JButton SendFastMode;
	private JTextField FastMode;
	private JButton SendWorldHardness;
	private JTextField WorldHardness;
	private JLabel jLabel10;
	private JPanel jPanel13;
	private AbstractAction SendWorldBouncinessAction;
	private JTextField WorldBounciness;
	private JButton WorldBouncinessSend;
	private JLabel jLabel9;
	private JPanel jPanel12;
	private AbstractAction SendWorldGravityAction;
	private JButton WorldGravitySend;
	private JTextField WorldGravity;
	private JButton PauseButton;
	private JPanel jPanel7;
	private JComboBox jComboBox1;
	private JButton SyncModeSend;
	private JLabel jLabel4;
	private JLabel jLabel8;
	private JPanel jPanel11;
	private AbstractAction SendSyncWait;
	private JButton SyncWaitSend;
	private JTextField SyncWait;
	private JLabel jLabel7;
	private JPanel jPanel10;
	private AbstractAction SendSyncModeAction;
	private AbstractAction AnyDataAction;
	private AbstractAction StepAction;
	private AbstractAction PlayAction;
	private AbstractAction InitializeAction;
	private AbstractAction SendStepSize;
	private JButton AnyDataSend;
	private JTextField AnyTextField;
	private JLabel jLabel6;
	private JPanel jPanel9;
	private JLabel jLabel5;
	private JPanel jPanel8;
	private JButton InitializeButton;
	private JButton PlayButton;
	private JButton StepButton;
	private AbstractAction PauseAction;
	private JPanel jPanel6;
	private JPanel jPanel5;
	private JButton StepSizeSend;
	private JTextField StepSize;
	private JLabel jLabel3;
	private AbstractAction ExitAction;
	private JButton jButton1;
	private JButton Conectar;
	private JTextField Port;
	private JLabel jLabel2;
	private JTextField IP;
	private JLabel jLabel1;
	private JPanel jPanel3;
	private JPanel jPanel2;
	private JSeparator jSeparator3;

	/**
	* Auto-generated main method to display this JFrame
	*/
	public static void main(String[] args) {		
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				FrontEnd inst = new FrontEnd();
				Receiver r1 = new Receiver(inst);
				r1.start();
				inst.setLocationRelativeTo(null);
				inst.setVisible(true);
			}
		});
	}
	
	public FrontEnd() {
		super();
		initGUI(); 
	}
	
	private void initGUI() {
		try {
			BorderLayout thisLayout = new BorderLayout();
			setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);		
			getContentPane().setLayout(thisLayout);
			this.setTitle("SimRob Commander");
			this.setResizable(false);
			{
				jSeparator2 = new JSeparator();
				getContentPane().add(jSeparator2, BorderLayout.NORTH);
				jSeparator2.setPreferredSize(new java.awt.Dimension(390, 59));
			}
			{
				jSeparator3 = new JSeparator();
				getContentPane().add(jSeparator3, BorderLayout.SOUTH);
				jSeparator3.setPreferredSize(new java.awt.Dimension(390, 44));
			}
			{
				jSeparator1 = new JSeparator();
				getContentPane().add(jSeparator1, BorderLayout.CENTER);
			}
			{
				jPanel2 = new JPanel();
				getContentPane().add(jPanel2, BorderLayout.NORTH);
				jPanel2.setPreferredSize(new java.awt.Dimension(946, 62));
				{
					final JPanel jPanel4 = new JPanel();
					jPanel2.add(jPanel4);
					FlowLayout jPanel4Layout = new FlowLayout();
					jPanel4.setLayout(jPanel4Layout);
					jPanel4.setPreferredSize(new java.awt.Dimension(131, 66));
					{
						jLabel1 = new JLabel();
						jPanel4.add(jLabel1);
						jLabel1.setText("IP");
						jLabel1.setLayout(null);
						jLabel1.setPreferredSize(new java.awt.Dimension(22, 27));
					}
					{
						IP = new JTextField();
						jPanel4.add(IP);
						IP.setPreferredSize(new java.awt.Dimension(90, 19));
					}
					{
						jLabel2 = new JLabel();
						jPanel4.add(jLabel2);
						jLabel2.setText("Port");
						jLabel2.setLayout(null);
					}
					{
						Port = new JTextField();
						jPanel4.add(Port);
						Port.setPreferredSize(new java.awt.Dimension(90, 19));
					}
				}
				{
					Conectar = new JButton();
					jPanel2.add(Conectar);
					Conectar.setText("Register Agent");
					Conectar.setAction(getAbstractAction1());
					Conectar.setPreferredSize(new java.awt.Dimension(128, 22));
				}

			}
			{
				jPanel3 = new JPanel();
				getContentPane().add(jPanel3, BorderLayout.SOUTH);
				jPanel3.setPreferredSize(new java.awt.Dimension(946, 24));
				{
					jButton1 = new JButton();
					jPanel3.add(jButton1);
					jButton1.setText("Exit Commander");
					jButton1.setAction(getExitAction());
					jButton1.setPreferredSize(new java.awt.Dimension(80, 17));
				}
			}
			{
				jPanel1 = new JPanel();
				getContentPane().add(jPanel1, BorderLayout.CENTER);
				jPanel1.setPreferredSize(new java.awt.Dimension(942, 574));
				jPanel1.add(getJPanel5());
				jPanel1.add(getJPanel6());
				jPanel1.add(getJPanel19());
				jPanel1.add(getJPanel10());
				jPanel1.add(getJPanel14());
				jPanel1.add(getJPanel11());
				jPanel1.add(getJPanel12());
				jPanel1.add(getJPanel13());
				jPanel1.add(getJPanel9());
				jPanel1.add(getJPanel15());
				jPanel1.add(getJPanel16());
				jPanel1.add(getJPanel17());
				jPanel1.add(getJPanel18());
				jPanel1.add(getJPanel20());
				jPanel1.add(getJPanel7());
				jPanel1.add(getJPanel8());
			}
			pack();
			this.setSize(952, 703);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void clearText()
	{
		this.jTextArea1.setText("");
		
	}
	
	public void addText(String text)
	{
		this.jTextArea1.setText(text+System.getProperty("line.separator")+this.jTextArea1.getText());
		
	}
	
	private AbstractAction getAbstractAction1() {
		if(abstractAction1 == null) {
			abstractAction1 = new AbstractAction("Register Agent", null) {
				public void actionPerformed(ActionEvent evt) {
					try {
						if (getIP().getText().length()>0 && getPort().getText().length()>0)
						{
							StringBuffer sb = new StringBuffer(1024);
							String path = System.getProperty("user.dir").toString();
							BufferedReader reader = new BufferedReader(new FileReader(path+ "/AgentRegistration.xml"));
							char[] chars = new char[1024];
							while ((reader.read(chars))>-1)
							{
								sb.append(String.valueOf(chars));
							}
							reader.close();
							String msgstr = sb.toString();
							byte msg[] = msgstr.getBytes();
							DatagramSocket dgsocket = new DatagramSocket();				
							InetAddress destination = InetAddress.getByName(getIP().getText());
							int port = Integer.parseInt(getPort().getText());
							DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
							dgsocket.send(datagram);
							dgsocket.close();
							/*Tengo q esperar respuesta cuando haya,,, ahora asumo q me conecto*/
							/*jPanel2.setEnabled(false);

							Component[] components = jPanel2.getComponents();
							if (components!=null && components.length >0)
							{
								int count = components.length;
								for(int i=0; i<count; i++)
								{
									components[i].setEnabled(false);
									if (components[i] instanceof JPanel)
									{
										((JPanel)components[i]).setEnabled(false);
										Component[] componentsin = ((JPanel)components[i]).getComponents();
										if (componentsin!=null && componentsin.length >0)
										{
											int countin = componentsin.length;
											for(int j=0; j<countin; j++)
											{
												componentsin[j].setEnabled(false);
												if (componentsin[j] instanceof JTextField)
												{
													((JTextField)componentsin[j]).setEnabled(false);
												}
											}
										}
									}
									else if (components[i] instanceof JButton)
									{
										((JButton)components[i]).setText("Connected");
									}
								}
							}*/
						}
					} catch (Exception e) {
						e.printStackTrace();
					}					
				}
			};
		}
		return abstractAction1;
	}
	public JTextField getIP() {
		return IP;
	}
	
	public JTextField getPort() {
		return Port;
	}
	
	private AbstractAction getExitAction() {
		if(ExitAction == null) {
			ExitAction = new AbstractAction("Exit", null) {
				public void actionPerformed(ActionEvent evt) {
						System.exit(0);
				}
			};
		}
		return ExitAction;
	}
	
	private JLabel getJLabel3() {
		if(jLabel3 == null) {
			jLabel3 = new JLabel();
			jLabel3.setText("Step Size");
			jLabel3.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel3;
	}
	
	public JTextField getStepSize() {
		if(StepSize == null) {
			StepSize = new JTextField();
			StepSize.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return StepSize;
	}
	
	private JButton getStepSizeSend() {
		if(StepSizeSend == null) {
			StepSizeSend = new JButton();
			StepSizeSend.setText("Send");
			StepSizeSend.setPreferredSize(new java.awt.Dimension(77, 22));
			StepSizeSend.setAction(getSendStepSize());
		}
		return StepSizeSend;
	}
	
	private JPanel getJPanel5() {
		if(jPanel5 == null) {
			jPanel5 = new JPanel();
			jPanel5.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel5.add(getJLabel3());
			jPanel5.add(getStepSize());
			jPanel5.add(getStepSizeSend());
		}
		return jPanel5;
	}
	
	private JPanel getJPanel6() {
		if(jPanel6 == null) {
			jPanel6 = new JPanel();
			jPanel6.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel6.add(getJLabel4());
			jPanel6.add(getJComboBox1());
			jPanel6.add(getSyncModeSend());
		}
		return jPanel6;
	}
	
	private JLabel getJLabel4() {
		if(jLabel4 == null) {
			jLabel4 = new JLabel();
			jLabel4.setText("Sync mode");
			jLabel4.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel4;
	}

	private JButton getSyncModeSend() {
		if(SyncModeSend == null) {
			SyncModeSend = new JButton();
			SyncModeSend.setText("Send");
			SyncModeSend.setPreferredSize(new java.awt.Dimension(77, 22));
			SyncModeSend.setAction(getSendSyncModeAction());
		}
		return SyncModeSend;
	}
	
	public JComboBox getJComboBox1() {
		if(jComboBox1 == null) {
			ComboBoxModel jComboBox1Model = 
				new DefaultComboBoxModel(
						new String[] { "Asynchronic", "Synchronic" });
			jComboBox1 = new JComboBox();
			jComboBox1.setModel(jComboBox1Model);
			jComboBox1.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return jComboBox1;
	}
	
	private JPanel getJPanel7() {
		if(jPanel7 == null) {
			jPanel7 = new JPanel();
			jPanel7.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel7.add(getInitializeButton());
			jPanel7.add(getPlayButton());
			jPanel7.add(getPauseButton());
			jPanel7.add(getStepButton());
		}
		return jPanel7;
	}
	
	private JButton getPauseButton() {
		if(PauseButton == null) {
			PauseButton = new JButton();
			PauseButton.setText("Pause");
			PauseButton.setAction(getPauseAction());
		}
		return PauseButton;
	}
	
	private AbstractAction getPauseAction() {
		if(PauseAction == null) {
			PauseAction = new AbstractAction("Pause", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					String message = "<Message><Simulation_Message><Control_Request Command=\"Set_Step_Mode\"><Response>true</Response><Step_Mode>true</Step_Mode></Control_Request></Simulation_Message></Message>";
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			};
		}
		return PauseAction;
	}
	
	private JButton getStepButton() {
		if(StepButton == null) {
			StepButton = new JButton();
			StepButton.setText("Step");
			StepButton.setAction(getStepAction());
		}
		return StepButton;
	}
	
	private JButton getPlayButton() {
		if(PlayButton == null) {
			PlayButton = new JButton();
			PlayButton.setText("Play");
			PlayButton.setAction(getPlayAction());
		}
		return PlayButton;
	}
	
	private JButton getInitializeButton() {
		if(InitializeButton == null) {
			InitializeButton = new JButton();
			InitializeButton.setText("Initialize");
			InitializeButton.setAction(getInitializeAction());
		}
		return InitializeButton;
	}
	
	private JPanel getJPanel8() {
		if(jPanel8 == null) {
			jPanel8 = new JPanel();
			FlowLayout jPanel8Layout = new FlowLayout();
			jPanel8.setPreferredSize(new java.awt.Dimension(803, 119));
			jPanel8.setLayout(jPanel8Layout);
			jPanel8.setBorder(BorderFactory.createEtchedBorder(BevelBorder.LOWERED));
			jPanel8.add(getJLabel5());
			jPanel8.add(getJScrollPane1());
			jPanel8.add(getClearMessages());
		}
		return jPanel8;
	}

	private JLabel getJLabel5() {
		if(jLabel5 == null) {
			jLabel5 = new JLabel();
			jLabel5.setText("Messages Received");
		}
		return jLabel5;
	}
	
	private JPanel getJPanel9() {
		if(jPanel9 == null) {
			jPanel9 = new JPanel();
			jPanel9.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel9.add(getJLabel6());
			jPanel9.add(getAnyTextField());
			jPanel9.add(getAnyDataSend());
		}
		return jPanel9;
	}
	
	private JLabel getJLabel6() {
		if(jLabel6 == null) {
			jLabel6 = new JLabel();
			jLabel6.setText("Any");
			jLabel6.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel6;
	}
	
	public JTextField getAnyTextField() {
		if(AnyTextField == null) {
			AnyTextField = new JTextField();
			AnyTextField.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return AnyTextField;
	}
	
	private JButton getAnyDataSend() {
		if(AnyDataSend == null) {
			AnyDataSend = new JButton();
			AnyDataSend.setText("Send");
			AnyDataSend.setPreferredSize(new java.awt.Dimension(77, 22));
			AnyDataSend.setAction(getAnyDataAction());
		}
		return AnyDataSend;
	}
	
	private AbstractAction getSendStepSize() {
		if(SendStepSize == null) {
			SendStepSize = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					if (getStepSize().getText().length()>0)
					{
						float stepsize = Float.parseFloat(getStepSize().getText());					
						String message = "<Message><Simulation_Message><Control_Request Command=\"Set_Timestep\"><Response>true</Response><Timestep>"+Float.toString(stepsize)+"</Timestep></Control_Request></Simulation_Message></Message>";
						byte msg[] = message.getBytes();
						DatagramSocket dgsocket;
						try {
							dgsocket = new DatagramSocket();
							InetAddress destination = InetAddress.getByName(getIP().getText());
							int port = Integer.parseInt(getPort().getText());
							DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
							dgsocket.send(datagram);
							dgsocket.close();
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}				
					}
				}
			};
		}
		return SendStepSize;
	}
	
	private AbstractAction getInitializeAction() {
		if(InitializeAction == null) {
			InitializeAction = new AbstractAction("Initialize", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					String message = "<Message><Simulation_Message><Control_Request Command=\"Initialize_Simulation\"><Response>true</Response></Control_Request></Simulation_Message></Message>";
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}	
				}
			};
		}
		return InitializeAction;
	}
	
	private AbstractAction getPlayAction() {
		if(PlayAction == null) {
			PlayAction = new AbstractAction("Play", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					String message = "<Message><Simulation_Message><Control_Request Command=\"Set_Step_Mode\"><Response>true</Response><Step_Mode>false</Step_Mode></Control_Request></Simulation_Message></Message>";
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			};
		}
		return PlayAction;
	}
	
	private AbstractAction getStepAction() {
		if(StepAction == null) {
			StepAction = new AbstractAction("Step", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					String message = "<Message><Simulation_Message><Control_Request Command=\"Make_Step\"><Response>true</Response></Control_Request></Simulation_Message></Message>";
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}	
				}
			};
		}
		return StepAction;
	}
	
	private AbstractAction getAnyDataAction() {
		if(AnyDataAction == null) {
			AnyDataAction = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					if (getAnyTextField().getText().length()>0)
					{										
						String message = getAnyTextField().getText();
						byte msg[] = message.getBytes();
						DatagramSocket dgsocket;
						try {
							dgsocket = new DatagramSocket();
							InetAddress destination = InetAddress.getByName(getIP().getText());
							int port = Integer.parseInt(getPort().getText());
							DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
							dgsocket.send(datagram);
							dgsocket.close();
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}				
					}
				}
			};
		}
		return AnyDataAction;
	}
	
	private AbstractAction getSendSyncModeAction() {
		if(SendSyncModeAction == null) {
			SendSyncModeAction = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					String syncmode;
					if (jComboBox1.getSelectedItem().toString().equals("Synchronic"))
					{
						syncmode = "true";
					}
					else
						syncmode = "false";
					
					String message = "<Message><Simulation_Message><Control_Request Command=\"Set_Sync_Mode\"><Response>true</Response><Sync_Mode>"+syncmode+"</Sync_Mode></Control_Request></Simulation_Message></Message>";
					
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);		
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			};
		}
		return SendSyncModeAction;
	}
	
	private JPanel getJPanel10() {
		if(jPanel10 == null) {
			jPanel10 = new JPanel();
			jPanel10.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel10.add(getJLabel7());
			jPanel10.add(getSyncWait());
			jPanel10.add(getSyncWaitSend());
		}
		return jPanel10;
	}
	
	private JLabel getJLabel7() {
		if(jLabel7 == null) {
			jLabel7 = new JLabel();
			jLabel7.setText("Sync Wait");
			jLabel7.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel7;
	}
	
	public JTextField getSyncWait() {
		if(SyncWait == null) {
			SyncWait = new JTextField();
			SyncWait.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return SyncWait;
	}
	
	private JButton getSyncWaitSend() {
		if(SyncWaitSend == null) {
			SyncWaitSend = new JButton();
			SyncWaitSend.setText("Send");
			SyncWaitSend.setPreferredSize(new java.awt.Dimension(77, 22));
			SyncWaitSend.setAction(getSendSyncWait());
		}
		return SyncWaitSend;
	}
	
	private AbstractAction getSendSyncWait() {
		if(SendSyncWait == null) {
			SendSyncWait = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt)
				{
					float syncwait = Float.parseFloat(getSyncWait().getText());					
					String message = "<Message><Simulation_Message><Control_Request Command=\"Set_Sync_Wait\"><Response>true</Response><Sync_Wait>"+Float.toString(syncwait)+"</Sync_Wait></Control_Request></Simulation_Message></Message>";
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}				
				}
			};
		}
		return SendSyncWait;
	}
	
	private JPanel getJPanel11() {
		if(jPanel11 == null) {
			jPanel11 = new JPanel();
			jPanel11.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel11.add(getJLabel8());
			jPanel11.add(getWorldGravity());
			jPanel11.add(getWorldGravitySend());
		}
		return jPanel11;
	}
	
	private JLabel getJLabel8() {
		if(jLabel8 == null) {
			jLabel8 = new JLabel();
			jLabel8.setText("World Gravity");
			jLabel8.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel8;
	}
	
	public JTextField getWorldGravity() {
		if(WorldGravity == null) {
			WorldGravity = new JTextField();
			WorldGravity.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return WorldGravity;
	}
	
	private JButton getWorldGravitySend() {
		if(WorldGravitySend == null) {
			WorldGravitySend = new JButton();
			WorldGravitySend.setText("Send");
			WorldGravitySend.setPreferredSize(new java.awt.Dimension(77, 22));
			WorldGravitySend.setAction(getSendWorldGravityAction());
		}
		return WorldGravitySend;
	}
	
	private AbstractAction getSendWorldGravityAction() {
		if(SendWorldGravityAction == null) {
			SendWorldGravityAction = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt)
				{
					if (getWorldGravity().getText().length()>0)
					{
						float worldgravity = Float.parseFloat(getWorldGravity().getText());					
						String message = "<Message><Simulation_Message><Control_Request Command=\"Set_World_Gravity\"><Response>true</Response><Gravity>"+Float.toString(worldgravity)+"</Gravity></Control_Request></Simulation_Message></Message>";
						byte msg[] = message.getBytes();
						DatagramSocket dgsocket;
						try {
							dgsocket = new DatagramSocket();
							InetAddress destination = InetAddress.getByName(getIP().getText());
							int port = Integer.parseInt(getPort().getText());
							DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
							dgsocket.send(datagram);
							dgsocket.close();
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}
			};
		}
		return SendWorldGravityAction;
	}
	
	private JPanel getJPanel12() {
		if(jPanel12 == null) {
			jPanel12 = new JPanel();
			jPanel12.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel12.add(getJLabel9());
			jPanel12.add(getWorldBounciness());
			jPanel12.add(getWorldBouncinessSend());
		}
		return jPanel12;
	}
	
	private JLabel getJLabel9() {
		if(jLabel9 == null) {
			jLabel9 = new JLabel();
			jLabel9.setText("World Bounciness");
			jLabel9.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel9;
	}

	private JButton getWorldBouncinessSend() {
		if(WorldBouncinessSend == null) {
			WorldBouncinessSend = new JButton();
			WorldBouncinessSend.setText("Send");
			WorldBouncinessSend.setPreferredSize(new java.awt.Dimension(77, 22));
			WorldBouncinessSend.setAction(getSendWorldBouncinessAction());
		}
		return WorldBouncinessSend;
	}
	
	public JTextField getWorldBounciness() {
		if(WorldBounciness == null) {
			WorldBounciness = new JTextField();
			WorldBounciness.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return WorldBounciness;
	}
	
	private AbstractAction getSendWorldBouncinessAction() {
		if(SendWorldBouncinessAction == null) {
			SendWorldBouncinessAction = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					if (getWorldBounciness().getText().length()>0)
					{
						float bounciness = Float.parseFloat(getWorldBounciness().getText());					
						String message = "<Message><Simulation_Message><Control_Request Command=\"Set_World_Bounciness\"><Response>true</Response><Bounciness>"+Float.toString(bounciness)+"</Bounciness></Control_Request></Simulation_Message></Message>";
						byte msg[] = message.getBytes();
						DatagramSocket dgsocket;
						try {
							dgsocket = new DatagramSocket();
							InetAddress destination = InetAddress.getByName(getIP().getText());
							int port = Integer.parseInt(getPort().getText());
							DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
							dgsocket.send(datagram);
							dgsocket.close();
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}				
					}
				}
			};
		}
		return SendWorldBouncinessAction;
	}
	
	private JPanel getJPanel13() {
		if(jPanel13 == null) {
			jPanel13 = new JPanel();
			jPanel13.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel13.add(getJLabel10());
			jPanel13.add(getWorldHardness());
			jPanel13.add(getSendWorldHardness());
		}
		return jPanel13;
	}
	
	private JLabel getJLabel10() {
		if(jLabel10 == null) {
			jLabel10 = new JLabel();
			jLabel10.setText("World Hardness");
			jLabel10.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel10;
	}
	
	public JTextField getWorldHardness() {
		if(WorldHardness == null) {
			WorldHardness = new JTextField();
			WorldHardness.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return WorldHardness;
	}
	
	private JButton getSendWorldHardness() {
		if(SendWorldHardness == null) {
			SendWorldHardness = new JButton();
			SendWorldHardness.setText("Send");
			SendWorldHardness.setPreferredSize(new java.awt.Dimension(77, 22));
			SendWorldHardness.setAction(getSendWorldHardnessAction());
		}
		return SendWorldHardness;
	}
	
	private AbstractAction getSendWorldHardnessAction() {
		if(SendWorldHardnessAction == null) {
			SendWorldHardnessAction = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					if (getWorldHardness().getText().length()>0)
					{
						float hardness = Float.parseFloat(getWorldHardness().getText());					
						String message = "<Message><Simulation_Message><Control_Request Command=\"Set_World_Hardness\"><Response>true</Response><Hardness>"+Float.toString(hardness)+"</Hardness></Control_Request></Simulation_Message></Message>";
						byte msg[] = message.getBytes();
						DatagramSocket dgsocket;
						try {
							dgsocket = new DatagramSocket();
							InetAddress destination = InetAddress.getByName(getIP().getText());
							int port = Integer.parseInt(getPort().getText());
							DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
							dgsocket.send(datagram);
							dgsocket.close();
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}				
					}
				}
			};
		}
		return SendWorldHardnessAction;
	}
	
	private JPanel getJPanel14() {
		if(jPanel14 == null) {
			jPanel14 = new JPanel();
			jPanel14.setPreferredSize(new java.awt.Dimension(395, 75));
			jPanel14.add(getJLabel11());
			jPanel14.add(getJLabel12());
			jPanel14.add(getEntityPositionId());
			jPanel14.add(getJLabel17());
			jPanel14.add(getSendPosition());
			jPanel14.add(getJLabel13());
			jPanel14.add(getJLabel14());
			jPanel14.add(getPositionX());
			jPanel14.add(getJLabel15());
			jPanel14.add(getPositionY());
			jPanel14.add(getJLabel16());
			jPanel14.add(getPositionZ());
			jPanel14.add(getJLabel18());
		}
		return jPanel14;
	}
	
	private JLabel getJLabel11() {
		if(jLabel11 == null) {
			jLabel11 = new JLabel();
			jLabel11.setText("                               Set Position");
			jLabel11.setPreferredSize(new java.awt.Dimension(326, 15));
			jLabel11.setBorder(BorderFactory.createEtchedBorder(BevelBorder.LOWERED));
		}
		return jLabel11;
	}
	
	private JLabel getJLabel12() {
		if(jLabel12 == null) {
			jLabel12 = new JLabel();
			jLabel12.setText("Entity");
			jLabel12.setPreferredSize(new java.awt.Dimension(78, 22));
		}
		return jLabel12;
	}
	
	public JTextField getEntityPositionId() {
		if(EntityPositionId == null) {
			EntityPositionId = new JTextField();
			EntityPositionId.setBounds(98, 79, 120, 22);
			EntityPositionId.setPreferredSize(new java.awt.Dimension(34, 22));
		}
		return EntityPositionId;
	}

	private JLabel getJLabel13() {
		if(jLabel13 == null) {
			jLabel13 = new JLabel();
			jLabel13.setText("       Position");
			jLabel13.setPreferredSize(new java.awt.Dimension(92, 15));
		}
		return jLabel13;
	}
	
	private JLabel getJLabel14() {
		if(jLabel14 == null) {
			jLabel14 = new JLabel();
			jLabel14.setText("X");
			jLabel14.setPreferredSize(new java.awt.Dimension(8, 17));
		}
		return jLabel14;
	}
	
	public JTextField getPositionX() {
		if(PositionX == null) {
			PositionX = new JTextField();
			PositionX.setPreferredSize(new java.awt.Dimension(36, 22));
		}
		return PositionX;
	}
	
	private JLabel getJLabel15() {
		if(jLabel15 == null) {
			jLabel15 = new JLabel();
			jLabel15.setText("     Y");
			jLabel15.setPreferredSize(new java.awt.Dimension(33, 17));
		}
		return jLabel15;
	}
	
	public JTextField getPositionY() {
		if(PositionY == null) {
			PositionY = new JTextField();
			PositionY.setPreferredSize(new java.awt.Dimension(34, 22));
		}
		return PositionY;
	}
	
	private JLabel getJLabel16() {
		if(jLabel16 == null) {
			jLabel16 = new JLabel();
			jLabel16.setText("      Z");
			jLabel16.setPreferredSize(new java.awt.Dimension(33, 17));
		}
		return jLabel16;
	}
	
	public JTextField getPositionZ() {
		if(PositionZ == null) {
			PositionZ = new JTextField();
			PositionZ.setPreferredSize(new java.awt.Dimension(34, 22));
		}
		return PositionZ;
	}
	
	private JLabel getJLabel17() {
		if(jLabel17 == null) {
			jLabel17 = new JLabel();
			jLabel17.setPreferredSize(new java.awt.Dimension(130, 15));
		}
		return jLabel17;
	}
	
	private JLabel getJLabel18() {
		if(jLabel18 == null) {
			jLabel18 = new JLabel();
			jLabel18.setPreferredSize(new java.awt.Dimension(84, 15));
		}
		return jLabel18;
	}
	
	private JButton getSendPosition() {
		if(SendPosition == null) {
			SendPosition = new JButton();
			SendPosition.setText("Send");
			SendPosition.setPreferredSize(new java.awt.Dimension(77, 22));
			SendPosition.setAction(getSendPositionAction());
		}
		return SendPosition;
	}
	
	private AbstractAction getSendPositionAction() {
		if(SendPositionAction == null) {
			SendPositionAction = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					if (getEntityPositionId().getText().length()>0)
					{
						int entityid = Integer.parseInt(getEntityPositionId().getText());
						float posx=0, posy=0, posz=0;
						if (getPositionX().getText().length()>0)
							posx = Float.parseFloat(getPositionX().getText());
						if (getPositionY().getText().length()>0)
							posy = Float.parseFloat(getPositionY().getText());
						if (getPositionZ().getText().length()>0)
							posz = Float.parseFloat(getPositionZ().getText());
						String message = "<Message><Simulation_Message><Entity_Request Command=\"Set_Entity_Position\"><Response>true</Response><Entity_Id>"+Integer.toString(entityid)+"</Entity_Id><Position_X>"+Float.toString(posx)+"</Position_X><Position_Y>"+Float.toString(posy)+"</Position_Y><Position_Z>"+Float.toString(posz)+"</Position_Z></Entity_Request></Simulation_Message></Message>";
						byte msg[] = message.getBytes();
						DatagramSocket dgsocket;
						try {
							dgsocket = new DatagramSocket();
							InetAddress destination = InetAddress.getByName(getIP().getText());
							int port = Integer.parseInt(getPort().getText());
							DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
							dgsocket.send(datagram);
							dgsocket.close();
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}		
						
					}
				}
			};
		}
		return SendPositionAction;
	}
	
	private JPanel getJPanel15() {
		if(jPanel15 == null) {
			jPanel15 = new JPanel();
			jPanel15.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel15.add(getJLabel19());
			jPanel15.add(getSaveFileName());
			jPanel15.add(getSendSaveToFile());
		}
		return jPanel15;
	}
	
	private JLabel getJLabel19() {
		if(jLabel19 == null) {
			jLabel19 = new JLabel();
			jLabel19.setText("Save to file");
			jLabel19.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel19;
	}

	private JButton getSendSaveToFile() {
		if(SendSaveToFile == null) {
			SendSaveToFile = new JButton();
			SendSaveToFile.setText("Send");
			SendSaveToFile.setPreferredSize(new java.awt.Dimension(77, 22));
			SendSaveToFile.setAction(getSendSaveFileAction());
		}
		return SendSaveToFile;
	}
	
	private AbstractAction getSendSaveFileAction() {
		if(SendSaveFileAction == null) {
			SendSaveFileAction = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					String message = "<Message><Simulation_Message><Control_Request Command=\"Save\"><Response>true</Response><File>"+getSaveFileName().getText()+"</File></Control_Request></Simulation_Message></Message>";
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}	
				}
			};
		}
		return SendSaveFileAction;
	}
	
	public JTextField getSaveFileName() {
		if(SaveFileName == null) {
			SaveFileName = new JTextField();
			SaveFileName.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return SaveFileName;
	}
	
	private JPanel getJPanel16() {
		if(jPanel16 == null) {
			jPanel16 = new JPanel();
			jPanel16.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel16.add(getJLabel20());
			jPanel16.add(getLoadFileName());
			jPanel16.add(getSendLoadFromFile());
		}
		return jPanel16;
	}
	
	private JLabel getJLabel20() {
		if(jLabel20 == null) {
			jLabel20 = new JLabel();
			jLabel20.setText("Load from file");
			jLabel20.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel20;
	}
	
	public JTextField getLoadFileName() {
		if(LoadFileName == null) {
			LoadFileName = new JTextField();
			LoadFileName.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return LoadFileName;
	}
	
	private JButton getSendLoadFromFile() {
		if(SendLoadFromFile == null) {
			SendLoadFromFile = new JButton();
			SendLoadFromFile.setText("Send");
			SendLoadFromFile.setPreferredSize(new java.awt.Dimension(77, 22));
			SendLoadFromFile.setAction(getLoadFromFileAction());
		}
		return SendLoadFromFile;
	}
	
	private AbstractAction getLoadFromFileAction() {
		if(LoadFromFileAction == null) {
			LoadFromFileAction = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt)
				{
					String message = "<Message><Simulation_Message><Control_Request Command=\"Load\"><Response>true</Response><File>"+getLoadFileName().getText()+"</File></Control_Request></Simulation_Message></Message>";
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}	
				}
			};
		}
		return LoadFromFileAction;
	}

	private JTextArea getJTextArea1() {
		if(jTextArea1 == null) {
			jTextArea1 = new JTextArea();
			jTextArea1.setBounds(309, 77, 68, 19);
			jTextArea1.setEditable(false);
		}
		return jTextArea1;
	}
	
	private JScrollPane getJScrollPane1() {
		if(jScrollPane1 == null) {
			jScrollPane1 = new JScrollPane(jTextArea1);
			jScrollPane1.setPreferredSize(new java.awt.Dimension(673, 67));

			//jScrollPane1.setViewportView(getJTextArea1());
			jScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			jScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
			jScrollPane1.setAutoscrolls(true);
			jScrollPane1.setViewportView(getJTextArea1());
		}
		return jScrollPane1;
	}
	
	private JPanel getJPanel17() {
		if(jPanel17 == null) {
			jPanel17 = new JPanel();
			jPanel17.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel17.add(getJLabel21());
			jPanel17.add(getStepsPerIteration());
			jPanel17.add(getSendStepsPerIteration());
		}
		return jPanel17;
	}
	
	private JLabel getJLabel21() {
		if(jLabel21 == null) {
			jLabel21 = new JLabel();
			jLabel21.setText("Steps Per Iteration");
			jLabel21.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel21;
	}
	
	public JTextField getStepsPerIteration() {
		if(StepsPerIteration == null) {
			StepsPerIteration = new JTextField();
			StepsPerIteration.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return StepsPerIteration;
	}
	
	private JButton getSendStepsPerIteration() {
		if(SendStepsPerIteration == null) {
			SendStepsPerIteration = new JButton();
			SendStepsPerIteration.setPreferredSize(new java.awt.Dimension(77, 22));
			SendStepsPerIteration.setText("Send");
			SendStepsPerIteration.setAction(getAbstractAction2());
		}
		return SendStepsPerIteration;
	}
	
	private AbstractAction getAbstractAction2() {
		if(abstractAction2 == null) {
			abstractAction2 = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					String message = "<Message><Simulation_Message><Control_Request Command=\"Set_Steps_Per_Iteration\"><Response>true</Response><Steps_Per_Iteration>"+getStepsPerIteration().getText()+"</Steps_Per_Iteration></Control_Request></Simulation_Message></Message>";
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}	
				}
			};
		}
		return abstractAction2;
	}
	
	private JPanel getJPanel18() {
		if(jPanel18 == null) {
			jPanel18 = new JPanel();
			jPanel18.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel18.add(getJLabel22());
			jPanel18.add(getFastMode());
			jPanel18.add(getSendFastMode());
		}
		return jPanel18;
	}
	
	private JLabel getJLabel22() {
		if(jLabel22 == null) {
			jLabel22 = new JLabel();
			jLabel22.setText("Fast Mode: ");
			jLabel22.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel22;
	}
	
	public JTextField getFastMode() {
		if(FastMode == null) {
			FastMode = new JTextField();
			FastMode.setPreferredSize(new java.awt.Dimension(120, 22));
		}
		return FastMode;
	}
	
	private JButton getSendFastMode() {
		if(SendFastMode == null) {
			SendFastMode = new JButton();
			SendFastMode.setText("Send");
			SendFastMode.setPreferredSize(new java.awt.Dimension(77, 22));
			SendFastMode.setAction(getSendFastModeAction());
		}
		return SendFastMode;
	}
	
	private AbstractAction getSendFastModeAction() {
		if(SendFastModeAction == null) {
			SendFastModeAction = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt) 
				{
					String message = "<Message><Simulation_Message><Control_Request Command=\"Set_Fast_Mode\"><Response>true</Response><Fast_Mode>"+getFastMode().getText()+"</Fast_Mode></Control_Request></Simulation_Message></Message>";
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}	
				}
			};
		}
		return SendFastModeAction;
	}
	
	private JPanel getJPanel19() {
		if(jPanel19 == null) {
			jPanel19 = new JPanel();
			jPanel19.setPreferredSize(new java.awt.Dimension(395, 48));
			jPanel19.add(getJLabel23());
			jPanel19.add(getJComboBox2());
			jPanel19.add(getSendAutoAdjustMode());
		}
		return jPanel19;
	}
	
	private JPanel getJPanel20() {
		if(jPanel20 == null) {
			jPanel20 = new JPanel();
			jPanel20.setPreferredSize(new java.awt.Dimension(395, 48));
		}
		return jPanel20;
	}
	
	private JLabel getJLabel23() {
		if(jLabel23 == null) {
			jLabel23 = new JLabel();
			jLabel23.setText("Auto-Adjust Mode");
			jLabel23.setPreferredSize(new java.awt.Dimension(128, 48));
		}
		return jLabel23;
	}
	
	private JComboBox getJComboBox2() {
		if(jComboBox2 == null) {
			ComboBoxModel jComboBox2Model = 
				new DefaultComboBoxModel(
						new String[] { "Off", "On" });
			jComboBox2 = new JComboBox();
			jComboBox2.setModel(jComboBox2Model);
			jComboBox2.setPreferredSize(new java.awt.Dimension(120,22));
		}
		return jComboBox2;
	}
	
	private JButton getSendAutoAdjustMode() {
		if(SendAutoAdjustMode == null) {
			SendAutoAdjustMode = new JButton();
			SendAutoAdjustMode.setText("Send");
			SendAutoAdjustMode.setPreferredSize(new java.awt.Dimension(77, 22));
			SendAutoAdjustMode.setAction(getAutoAdjustModeAction());
		}
		return SendAutoAdjustMode;
	}
	
	private AbstractAction getAutoAdjustModeAction() {
		if(AutoAdjustModeAction == null) {
			AutoAdjustModeAction = new AbstractAction("Send", null) {
				public void actionPerformed(ActionEvent evt) {
					String autoadjustmode;
					if (jComboBox2.getSelectedItem().toString().equals("On"))
					{
						autoadjustmode = "true";
					}
					else
						autoadjustmode = "false";
					
					String message = "<Message><Simulation_Message><Control_Request Command=\"Set_AutoAdjust_Mode\"><Response>true</Response><AutoAdjust_Mode>"+autoadjustmode+"</AutoAdjust_Mode></Control_Request></Simulation_Message></Message>";
					
					byte msg[] = message.getBytes();
					DatagramSocket dgsocket;
					try {
						dgsocket = new DatagramSocket();
						InetAddress destination = InetAddress.getByName(getIP().getText());
						int port = Integer.parseInt(getPort().getText());
						DatagramPacket datagram = new DatagramPacket(msg, msg.length,destination, port);
						dgsocket.send(datagram);		
						dgsocket.close();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			};
		}
		return AutoAdjustModeAction;
	}
	
	private JButton getClearMessages() {
		if(ClearMessages == null) {
			ClearMessages = new JButton();
			ClearMessages.setText("Clear Messages");
			ClearMessages.setAction(getClearMessagesAction());
			ClearMessages.setPreferredSize(new java.awt.Dimension(142, 15));
		}
		return ClearMessages;
	}
	
	private AbstractAction getClearMessagesAction() {
		if(ClearMessagesAction == null) {
			ClearMessagesAction = new AbstractAction("Clear Messages", null) {
				public void actionPerformed(ActionEvent evt) {
					clearText();
				}
			};
		}
		return ClearMessagesAction;
	}

}
